local original_keyBinding = keyBinding;
keyBinding = {};
for i=1, #original_keyBinding do
	table.insert(keyBinding, original_keyBinding[i]);
	if original_keyBinding[i].value == "[Combat]" then
		table.insert(keyBinding, {value = "Mandela Dodge", key = Keyboard.KEY_Q});
	end
end

local function StrReplace(thisString, findThis, replaceWithThis)
	return string.gsub(thisString, "("..findThis..")", replaceWithThis);
end

local function IsIn(big,small)
	local temp = StrReplace(big,small,"");
	if(temp == big) then
	return false
	else 
	return true;
	end
end

MandelaDodgeClient = {};

function MandelaDodgeClient.OnKeyStartPressed(keyNumber)
	if keyNumber == getCore():getKey("Mandela Dodge") then
		local player = getPlayer();
		if MandelaDodgeClient.canDodge(player) then
			MandelaDodgeClient.dodge(player);
		end
	end
end

function MandelaDodgeClient.canDodge(player)
	return ((not player:getModData().MandelaDodge.isDodging) and (player:getModData().MandelaDodge.speed < 0.03 or player:isAiming()));
end

function MandelaDodgeClient.dodge(player)
	local modData = player:getModData().MandelaDodge;
	modData.isDodging = true;
	local endurance = player:getStats():getEndurance();
	modData.dodgeSpeed = 0.10*endurance;
	modData.dodgeDirection = player:getDir():toAngle();
	modData.DodgerXSpeed = 0;
	modData.DodgerYSpeed = 0;
	modData.dodgeTime = 15;
	modData.DodgerStartX = player:getX();
	modData.DodgerStartY = player:getY();
	modData.stillPushing = true;
	local inventoryWeightFactor = player:getInventoryWeight(); if inventoryWeightFactor < 0 then inventoryWeightFactor = 0; end
	local playerWeightFactor = player:getNutrition():getWeight(); if playerWeightFactor < 80 then playerWeightFactor = 80; end
	modData.dodgeAcceleration = 0.01 * (80/(playerWeightFactor+inventoryWeightFactor))*endurance;
	endurance = endurance - (0.003 * ((playerWeightFactor+inventoryWeightFactor)/80)); if endurance < 0 then endurance = 0; end
	player:getStats():setEndurance(endurance);
end

function MandelaDodgeClient.stopDodging(player)
	player:getModData().MandelaDodge = {isDodging = false, speed = player:getModData().MandelaDodge.speed};
end

function MandelaDodgeClient.OnLoad()
	getPlayer():getModData().MandelaDodge = {isDodging = false};
end

function MandelaDodgeClient.onPlayerUpdate(player)

	if player:isLocalPlayer() == true then
		local modData = player:getModData().MandelaDodge;
		local newX = player:getX();
		local newY = player:getY();
		if modData.earlierX ~= nil and modData.earlierY ~= nil then
			local xDifference = (newX - modData.earlierX);
			local yDifference = (newY - modData.earlierY);
			modData.speed = math.sqrt((xDifference^2)+(yDifference^2));
		end
		modData.earlierX = player:getX();
		modData.earlierY = player:getY();
		if player:getModData().MandelaDodge.isDodging then
			
			local Collision = false;
			
			local DodgerStartX = modData.DodgerStartX;
			local DodgerStartY = modData.DodgerStartY;
			local DodgerX = player:getX();
			local DodgerY = player:getY();
			local DodgerZ = player:getZ();
			local DodgerCellZ = math.floor(DodgerZ);
			local DodgerXSpeed = modData.DodgerXSpeed;
			local DodgerYSpeed = modData.DodgerYSpeed;
			local dodgeDirection = modData.dodgeDirection;
			
			local timeMultiplier = getGameTime():getMultiplier();
			
			local X1 = DodgerStartX - (math.floor(DodgerStartX/100)*100);
			local X2 = DodgerX - (math.floor(DodgerX/100)*100);
			local Y1 = DodgerStartY - (math.floor(DodgerStartY/100)*100);
			local Y2 = DodgerY - (math.floor(DodgerY/100)*100);
			local X3 = X1 - X2;
			local Y3 = Y1 - Y2;
			local D = math.sqrt((X3^2)+(Y3^2))
			if modData.stillPushing then
				if (not (D > 0.1)) then
					if math.sqrt((DodgerXSpeed^2)+(DodgerYSpeed^2)) < modData.dodgeSpeed then
						DodgerXSpeed = DodgerXSpeed + (math.sin(dodgeDirection) * modData.dodgeAcceleration * timeMultiplier);
						DodgerYSpeed = DodgerYSpeed + (math.cos(dodgeDirection) * modData.dodgeAcceleration * timeMultiplier);
					end
				else
					modData.stillPushing = false;
				end
			end
			
			DodgerXSpeed = DodgerXSpeed * ( 1 - (0.02*timeMultiplier));
			DodgerYSpeed = DodgerYSpeed * ( 1 - (0.02*timeMultiplier));
			
			local divisions = 2;
			for i2=1,divisions do
				if Collision == false then
					
					DodgerX = DodgerX + (DodgerXSpeed/divisions);
					DodgerY = DodgerY + (DodgerYSpeed/divisions);
					
					local Cell = getWorld():getCell();
					local targetCell = nil;
					if modData.MandelaBowAndArrowTarget ~= nil then 
						targetCell = modData.MandelaBowAndArrowTarget:getCell();
					end
					
					local Square = Cell:getGridSquare(DodgerX,DodgerY,DodgerZ);
					local upSquare = Cell:getGridSquare(DodgerX,DodgerY,DodgerZ+1);
					
					local sideSquare = Cell:getGridSquare(DodgerX+1,DodgerY,DodgerZ);
					
					local backSquare = Cell:getGridSquare(DodgerX,DodgerY+1,DodgerZ);
					
					local otherSideSquare = Cell:getGridSquare(DodgerX-1,DodgerY,DodgerZ);
					
					local otherBackSquare = Cell:getGridSquare(DodgerX,DodgerY-1,DodgerZ);
					
					if Square ~= nil then
						if DodgerZ < DodgerCellZ then
							local Square2 = getWorld():getCell():getGridSquare(DodgerX,DodgerY,DodgerCellZ);
							if Square2 == nil and targetCell ~= nil then
								Square2 = targetCell:getGridSquare(DodgerX,DodgerY,DodgerCellZ);
							end
							if Square2 ~= nil then
								if Square2:isSolidFloor() then Collision = true; end
							end
						end
						
						lastXoff = DodgerX - math.floor(DodgerX);
						lastYoff = DodgerY - math.floor(DodgerY);
						lastZoff = DodgerZ - math.floor(DodgerZ);
						if DodgerZ < 0.001 then lastZoff = 0; end

						if DodgerZ < 0 then
							DodgerZ = 0;
							Collision = true;
						else
							local objects = Square:getObjects();
							for ii=0, objects:size()-1 do
								if(player:getZ() < 3) then
									local collision = false;
									local wall = false;
									if (IsIn(tostring(objects:get(ii):getType()),"stair")) then collision = true; end
									if (objects:get(ii):getObjectName() == "Tree") and lastXoff > 0.25 and lastXoff < 0.75 and lastYoff > 0.25 and lastYoff < 0.75 then collision = true; end
									if ((tostring(objects:get(ii):getType()) == "wall") 
									or (objects:get(ii):getObjectName() == "Door") 
									or (objects:get(ii):getObjectName() == "Window")) then
										if lastXoff < 0.3/divisions or lastYoff < 0.3/divisions then collision = true; wall = true; end
									end
									if collision then
										--player:Say("Square collision");
										CObject = objects:get(ii);
										Collision = true;
										
										if wall and DodgerXSpeed > 0 and lastXoff < 0.3/divisions and DodgerXSpeed^2 > DodgerYSpeed^2 and otherSideSquare ~= nil then
											Square = otherSideSquare; 
											DodgerX = math.floor(DodgerX) - 0.05;
											lastXoff = DodgerX - math.floor(DodgerX);
											--player:Say("Adjusting on X");
										end
										if wall and DodgerYSpeed > 0 and lastYoff < 0.3/divisions and DodgerYSpeed^2 > DodgerXSpeed^2 and otherBackSquare ~= nil then
											Square = otherBackSquare; 
											DodgerY = math.floor(DodgerY) - 0.05;
											lastYoff = DodgerY - math.floor(DodgerY);
											--player:Say("Adjusting on Y");
										end
									end
								end
							end
							if sideSquare ~= nil then
								objects = sideSquare:getObjects();
								for ii=0, objects:size()-1 do
									if(player:getZ() < 3) then
										local collision = false;
										if (tostring(objects:get(ii):getType()) == "wall") 
										or (objects:get(ii):getObjectName() == "Door") 
										or (objects:get(ii):getObjectName() == "Window") then
											if lastXoff > 1-(0.3/divisions) then collision = true; end
										end
										if collision then
											--player:Say("sideSquare collision");
											CObject = objects:get(ii);
											Collision = true;
											
											if DodgerXSpeed < 0 and lastXoff > 1-(0.3/divisions) and DodgerXSpeed^2 > DodgerYSpeed^2 then
												Square = sideSquare; 
												DodgerX = math.floor(DodgerX) + 1.05;
												lastXoff = DodgerX - math.floor(DodgerX);
												--player:Say("Adjusting on X 2");
											end
										end
									end
								end
							end
							if backSquare ~= nil then
								objects = backSquare:getObjects();
								for ii=0, objects:size()-1 do
									if(player:getZ() < 3) then
										local collision = false;
										if (tostring(objects:get(ii):getType()) == "wall") 
										or (objects:get(ii):getObjectName() == "Door") 
										or (objects:get(ii):getObjectName() == "Window") then
											if lastYoff > 1-(0.3/divisions) then collision = true; end
										end
										if collision then
											--player:Say("backSquare collision");
											CObject = objects:get(ii);
											Collision = true;
											
											if DodgerYSpeed < 0 and lastYoff > 1-(0.3/divisions) and DodgerYSpeed^2 > DodgerXSpeed^2 then
												Square = backSquare; 
												DodgerY = math.floor(DodgerY) + 1.05;
												lastYoff = DodgerY - math.floor(DodgerY);
												--player:Say("Adjusting on Y 2");
											end
										end
									end
								end
							end
						end
					end
					
					if Collision then
						MandelaDodgeClient.stopDodging(player);
					else
						player:setX(DodgerX);
						player:setY(DodgerY);
						modData.DodgerX = DodgerX;
						modData.DodgerY = DodgerY;
						modData.DodgerXSpeed = DodgerXSpeed;
						modData.DodgerYSpeed = DodgerYSpeed;
					end
				end
			end
			if not modData.stillPushing then
				modData.dodgeTime = modData.dodgeTime - timeMultiplier;
				if modData.dodgeTime < 0 then
					MandelaDodgeClient.stopDodging(player);
				end
			end
		end
	end
end

Events.OnKeyStartPressed.Add(MandelaDodgeClient.OnKeyStartPressed);
Events.OnPlayerUpdate.Add(MandelaDodgeClient.onPlayerUpdate);
Events.OnLoad.Add(MandelaDodgeClient.OnLoad);